<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

use Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;

final class FinmoPayments_Blocks extends AbstractPaymentMethodType {

    protected $name = 'finmo_payments';

    public function initialize() {
        $this->settings = get_option( 'woocommerce_finmo_payments_settings', array() );

        // Register JS file for Blocks checkout
        $script_path = FINMO_PAYMENTS_PLUGIN_URL . 'js/finmo-blocks.js';
        $script_file = FINMO_PAYMENTS_PLUGIN_PATH . 'js/finmo-blocks.js';
        $script_ver  = file_exists( $script_file ) ? filemtime( $script_file ) : ( defined( 'FINMO_PAYMENTS_VERSION' ) ? FINMO_PAYMENTS_VERSION : time() );

        if ( ! empty( $script_path ) ) {
            wp_register_script(
                'finmo-payments-blocks',
                $script_path,
                array( 'wc-blocks-registry', 'wc-settings', 'wp-element', 'wp-html-entities' ),
                $script_ver,
                true
            );

            // Provide logo URL for Blocks label image
            $logo_url = apply_filters( 'finmo_blocks_logo_url', FINMO_PAYMENTS_PLUGIN_URL . 'assets/finmo-logo.png' );
            wp_localize_script( 'finmo-payments-blocks', 'FinmoBlocksSettings', array(
                'logoUrl' => esc_url( $logo_url ),
            ) );
        } else {
            finmo_log('[FinmoPayments_Blocks] JS file missing: ' . $script_path);
        }
    }

    public function enqueue_assets() {
        try {
            if ( $this->is_active() ) {
                // Ensure script is registered before enqueueing
                if ( wp_script_is( 'finmo-payments-blocks', 'registered' ) ) {
                    wp_enqueue_script( 'finmo-payments-blocks' );

                    // Enforce larger logo and container area for Blocks checkout
                    $css = '.wc-block-components-radio-control__option[data-payment-method-id="finmo_payments"] .wc-block-components-radio-control__label{min-height:84px !important;display:flex !important;align-items:center !important;gap:12px !important;}'
                        . '.wc-block-components-radio-control__option[data-payment-method-id="finmo_payments"] .wc-block-components-radio-control__label > span{display:flex !important;align-items:center !important;gap:12px !important;}'
                        . '.wc-block-components-radio-control__option[data-payment-method-id="finmo_payments"] .wc-block-components-radio-control__label img{height:72px !important;max-height:none !important;width:auto !important;display:inline-block !important;vertical-align:middle !important;}';
                    wp_register_style( 'finmo-blocks-frontend', false );
                    wp_enqueue_style( 'finmo-blocks-frontend' );
                    wp_add_inline_style( 'finmo-blocks-frontend', $css );
                } else {
                    finmo_log('[FinmoPayments_Blocks] Tried to enqueue unregistered script.');
                }
            }
        } catch ( Exception $e ) {
            // Catch unexpected enqueue errors
            finmo_log('[FinmoPayments_Blocks] enqueue_assets failed: ' . $e->getMessage());
        }
    }

    // Checks if finmo payment method is enabled
    public function is_active() {
        try {
            return isset( $this->settings['enabled'] ) && 'yes' === $this->settings['enabled'];
        } catch ( Exception $e ) {
            finmo_log('[FinmoPayments_Blocks] is_active check failed: ' . $e->getMessage());
            return false; // Fail gracefully
        }
    }

    public function get_payment_method_data() {
        return array(
            'title'       => $this->settings['title'] ?? __( 'Finmo Payments', 'finmo-payments' ),
            'description' => $this->settings['description'] ?? __( 'Pay securely with Finmo.', 'finmo-payments' ),
            'supports'    => array( 'products', 'refunds' ),
        );
    }

    // Scripts to enqueue when WooCommerce renders the block-based checkout
    public function get_payment_method_script_handles() {
        if ( wp_script_is( 'finmo-payments-blocks', 'registered' ) ) {
            return array( 'finmo-payments-blocks' );
        }

        finmo_log('[FinmoPayments_Blocks] Script handle not available.');
        return array();
    }
}